//
//  MCReportNewTemplate.h
//  MCReporting
//
//  Created by Alykhan Jetha on 12/11/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <MCApplication/MCWindowController.h>

@class MCReportWrapper;

@interface MCReportNewTemplate : MCWindowController {
	IBOutlet NSTabView *tabView;
	IBOutlet NSButton *nextButton;
	IBOutlet NSButton *previousButton;
	
	IBOutlet NSMatrix *startingTypeMatrix;
	IBOutlet NSMatrix *behaviorMatrix;
	
	IBOutlet NSArrayController *areasController;
	IBOutlet NSObjectController *printInfoController;
	IBOutlet NSObjectController *otherInfoController;
	IBOutlet NSArrayController *otherTemplatesController;
	
	IBOutlet NSTableView *otherTemplatesTableView;
	
	IBOutlet NSView *previewView;
	
	IBOutlet NSButton *changeLabelButton;
	IBOutlet NSTextField *labelAreaTitleField;
	IBOutlet NSTextField *labelProductField;
	IBOutlet NSTextField *labelDescriptionField;
	
	MCReportWrapper *desiredTemplateWrapper;
	NSDictionary *selectedArea;
	NSString *currentBehaviorKey;
	
}

+ (void)setDesiredStartingBehavior:(NSString *)desireStart entityName:(NSString *)entityName;
+ (void)clearDesiredStartingBehaviorAndEntity;
+ (NSString *)desiredStartingBehavior;
+ (NSString *)desiredStartingEntityName;

- (NSDictionary *)selectedArea;
- (void)setSelectedArea:(NSDictionary *)aSelectedArea;

- (NSString *)currentBehaviorKey;
- (void)setCurrentBehaviorKey:(NSString *)aCurrentBehaviorKey;

- (MCReportWrapper *)desiredTemplateWrapper;
- (void)setDesiredTemplateWrapper:(MCReportWrapper *)aDesiredTemplateWrapper;

// calls setCurrentBehaviorKey, resets the UI with values for that behavior
- (void)changeToBehavior:(NSString *)aBehav;
- (int)tagForBehavior:(NSString *)aBehav;
- (void)reloadPreview;

- (IBAction)changeBehavior:(id)sender;
- (IBAction)changePaperSize:(id)sender;
- (IBAction)changeStartingType:(id)sender;
- (IBAction)changeLabelPreset:(id)sender;

- (IBAction)close:(id)sender;
- (IBAction)next:(id)sender;
- (IBAction)previous:(id)sender;

@end
